/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.plugin.minecraft;

import com.agricraft.agricraft.api.crop.AgriCrop;
import com.agricraft.agricraft.api.genetic.AgriGenePair;
import com.agricraft.agricraft.api.plant.AgriPlantModifierFactoryRegistry;
import com.agricraft.agricraft.api.plant.IAgriPlantModifier;
import java.util.Optional;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2473;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_4771;
import net.minecraft.class_5712;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinecraftPlantModifiers {
    public static void register() {
        AgriPlantModifierFactoryRegistry.register("agricraft:brightness", info -> Optional.of(new BrightnessPlantModifier()));
        AgriPlantModifierFactoryRegistry.register("agricraft:burn", info -> Optional.of(new BurnPlantModifier()));
        AgriPlantModifierFactoryRegistry.register("agricraft:bushy", info -> Optional.of(new BushyPlantModifier()));
        AgriPlantModifierFactoryRegistry.register("agricraft:experience", info -> Optional.of(new ExperiencePlantModifier()));
        AgriPlantModifierFactoryRegistry.register("agricraft:fungus", info -> {
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(new class_2960(info.value()));
            if (block instanceof class_4771) {
                class_4771 fungus = (class_4771)block;
                return Optional.of(new FungusPlantModifier(fungus));
            }
            return Optional.empty();
        });
        AgriPlantModifierFactoryRegistry.register("agricraft:poison", info -> Optional.of(new PoisonPlantModifier()));
        AgriPlantModifierFactoryRegistry.register("agricraft:redstone", info -> Optional.of(new RedstonePlantModifier()));
        AgriPlantModifierFactoryRegistry.register("agricraft:summon", info -> {
            if (class_7923.field_41177.method_10250(new class_2960(info.value()))) {
                return Optional.of(new SummonPlantModifier((class_1299)class_7923.field_41177.method_10223(new class_2960(info.value()))));
            }
            return Optional.empty();
        });
        AgriPlantModifierFactoryRegistry.register("agricraft:thorns", info -> Optional.of(new ThornsPlantModifier()));
        AgriPlantModifierFactoryRegistry.register("agricraft:tree", info -> {
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(new class_2960(info.value()));
            if (block instanceof class_2256) {
                class_2256 sapling = (class_2256)block;
                return Optional.of(new TreePlantModifier(sapling));
            }
            return Optional.empty();
        });
        AgriPlantModifierFactoryRegistry.register("agricraft:wither", info -> Optional.of(new WitherPlantModifier()));
    }

    public static class BrightnessPlantModifier
    implements IAgriPlantModifier {
        public static final String ID = "agricraft:brightness";

        @Override
        public int getBrightness(AgriCrop crop) {
            return (int)(16.0 * crop.getGrowthPercent());
        }
    }

    public static class BurnPlantModifier
    implements IAgriPlantModifier {
        public static final String ID = "agricraft:burn";

        @Override
        public void onEntityCollision(AgriCrop crop, class_1297 entity) {
            entity.method_5639((int)crop.getGenome().getStatGenes().stream().map(AgriGenePair::getTrait).mapToInt(i -> i).average().orElse(0.0));
        }
    }

    public static class BushyPlantModifier
    implements IAgriPlantModifier {
        public static final String ID = "agricraft:bushy";

        @Override
        public void onEntityCollision(AgriCrop crop, class_1297 entity) {
            entity.method_5844(crop.method_11010(), new class_243(0.8, 0.75, 0.8));
        }
    }

    public static class ExperiencePlantModifier
    implements IAgriPlantModifier {
        public static final String ID = "agricraft:experience";

        @Override
        public void onHarvest(AgriCrop crop, @Nullable class_1309 entity) {
            if (crop.method_10997() != null && !crop.method_10997().field_9236) {
                for (int i = 0; i < crop.getGenome().getGain(); ++i) {
                    if (i != 0 && !(crop.method_10997().method_8409().method_43058() < 0.5)) continue;
                    class_2338 pos = crop.method_11016();
                    crop.method_10997().method_8649((class_1297)new class_1303(crop.method_10997(), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 4));
                }
            }
        }
    }

    public static class FungusPlantModifier
    implements IAgriPlantModifier {
        public static final String ID = "agricraft:fungus";
        private final class_4771 fungus;

        public FungusPlantModifier(class_4771 fungus) {
            this.fungus = fungus;
        }

        @Override
        public Optional<class_1269> onRightClickPre(AgriCrop crop, @NotNull class_1799 stack, @Nullable class_1297 entity) {
            class_1937 level = crop.method_10997();
            if (stack.method_7960() || stack.method_7909() != class_1802.field_8324 || crop.method_10997() == null || !crop.canBeHarvested() || !this.fungus.method_9651((class_4538)level, crop.method_11016(), crop.method_11010(), level.field_9236)) {
                return Optional.empty();
            }
            if (this.fungus.method_9650(level, level.field_9229, crop.method_11016(), crop.method_11010())) {
                this.fungus.method_9652((class_3218)level, level.field_9229, crop.method_11016(), crop.method_11010());
                level.method_20290(2005, crop.method_11016(), 0);
            }
            stack.method_7934(1);
            return Optional.of(class_1269.field_5812);
        }
    }

    public static class PoisonPlantModifier
    implements IAgriPlantModifier {
        public static final String ID = "agricraft:poison";

        @Override
        public void onEntityCollision(AgriCrop crop, class_1297 entity) {
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                if (!(entity.method_21751() || entity.method_37908().field_9236 || livingEntity.method_6059(class_1294.field_5899))) {
                    livingEntity.method_6092(new class_1293(class_1294.field_5899, (int)(20.0 * crop.getGenome().getStatGenes().stream().map(AgriGenePair::getTrait).mapToInt(i -> i).average().orElse(0.0))));
                }
            }
        }
    }

    public static class RedstonePlantModifier
    implements IAgriPlantModifier {
        public static final String ID = "agricraft:redstone";

        @Override
        public int getBrightness(AgriCrop crop) {
            return (int)(15.0 * crop.getGrowthPercent());
        }
    }

    public static class SummonPlantModifier
    implements IAgriPlantModifier {
        public static final String ID = "agricraft:summon";
        private final class_1299<?> entityType;

        public SummonPlantModifier(class_1299<?> entityType) {
            this.entityType = entityType;
        }

        @Override
        public void onHarvest(AgriCrop crop, @Nullable class_1309 entity) {
            if (entity instanceof class_1657) {
                class_3218 serverLevel;
                class_1657 player = (class_1657)entity;
                class_1937 class_19372 = crop.method_10997();
                if (class_19372 instanceof class_3218 && this.entityType.method_5894(serverLevel = (class_3218)class_19372, null, player, crop.method_11016(), class_3730.field_16471, true, false) != null) {
                    serverLevel.method_33596((class_1297)player, class_5712.field_28738, crop.method_11016());
                }
            }
        }
    }

    public static class ThornsPlantModifier
    implements IAgriPlantModifier {
        public static final String ID = "agricraft:thorns";

        @Override
        public void onEntityCollision(AgriCrop crop, class_1297 entity) {
            class_1542 itemEntity;
            if (entity instanceof class_1542 && (itemEntity = (class_1542)entity).method_6985() < 100) {
                return;
            }
            double damage = crop.getGrowthPercent() * crop.getGenome().getStatGenes().stream().map(AgriGenePair::getTrait).mapToInt(i -> i).average().orElse(0.0);
            entity.method_5643(crop.method_10997().method_48963().method_48826(), (float)damage);
        }
    }

    public static class TreePlantModifier
    implements IAgriPlantModifier {
        public static final String ID = "agricraft:tree";
        private final class_2256 sapling;

        public TreePlantModifier(class_2256 sapling) {
            this.sapling = sapling;
        }

        @Override
        public Optional<class_1269> onRightClickPre(AgriCrop crop, @NotNull class_1799 stack, @Nullable class_1297 entity) {
            class_3218 serverLevel;
            class_1937 level;
            block7: {
                block6: {
                    level = crop.method_10997();
                    if (stack.method_7960() || stack.method_7909() != class_1802.field_8324 || crop.method_10997() == null || !crop.canBeHarvested() || !(level instanceof class_3218)) break block6;
                    serverLevel = (class_3218)level;
                    if (this.sapling.method_9651((class_4538)level, crop.method_11016(), crop.method_11010(), level.field_9236)) break block7;
                }
                return Optional.empty();
            }
            if (this.sapling.method_9650(level, level.field_9229, crop.method_11016(), crop.method_11010())) {
                class_2680 state = ((class_2248)this.sapling).method_9564();
                if (state.method_28498((class_2769)class_2473.field_11476)) {
                    state = (class_2680)state.method_11657((class_2769)class_2473.field_11476, (Comparable)Integer.valueOf(1));
                }
                class_2487 before = crop.asBlockEntity().method_38244();
                this.sapling.method_9652(serverLevel, serverLevel.method_8409(), crop.method_11016(), state);
                if (serverLevel.method_8320(crop.method_11016()).method_26204().equals(this.sapling)) {
                    serverLevel.method_8501(crop.method_11016(), crop.method_11010());
                    serverLevel.method_8321(crop.method_11016()).method_11014(before);
                    return Optional.of(class_1269.field_21466);
                }
                serverLevel.method_20290(2005, crop.method_11016(), 0);
            }
            stack.method_7934(1);
            return Optional.of(class_1269.field_5812);
        }
    }

    public static class WitherPlantModifier
    implements IAgriPlantModifier {
        public static final String ID = "agricraft:wither";

        @Override
        public void onEntityCollision(AgriCrop crop, class_1297 entity) {
            if (entity instanceof class_1309) {
                class_1293 wither = new class_1293(class_1294.field_5920, (int)(10.0 * crop.getGenome().getStatGenes().stream().map(AgriGenePair::getTrait).mapToInt(i -> i).average().orElse(0.0)));
                ((class_1309)entity).method_6092(wither);
            }
        }
    }
}

